//Author: Tom Uijlenhoet
//Date: 10-10-2021
//Inspired by: Japanese art and architecture.
//This code generates an output that should look like a 
//pleasing landscape in the moonlight. The sketch 
//consists of a moon with a gradient that should make 
//it look like the sunlight is reflecting on it. 
//Furthermore, the main object is the torii gate, 
//which is a Japanese object that really 
//inspires me. It should look like the light
//coming from the reflecting moon hits the
//gate from the side and the viewer sees the gate from
//the side that is in the shadow. In the back there are 
//some mountains, also really dark, because it is night.
//I made smaller and bigger stars, which will show up at 
//a random other place in the sky everytime you refresh
//the output. The same goes for the waves. And last but
//least, the reflection from the light, coming from the
//reflecting moon, on the watersurface is made by a 
//gradient. The proportions of the sky and the sea are
//2/3 1/3 in vertical directions and the same goes for 
//the torii gate, but in horizontal directions. I tried 
//to use blue, red and green, because they are the three
//basic colors in programming.
//I did not copy work from internet, but I used some 
//codes from the online lectures and then changed them
//for how I wanted them to look like.

float     r = 140;                                      //the dimensions of the moon
float[][] distances;
float     maxDist;
int       spacer;
float[]   seaGradient;        


void setup()
{
  size(1000, 600);                                       //measurements of the sketch
  
  maxDist = dist(width/2, height/2, width, height);      //setup for the lighting from the reflecting moon
  distances = new float[width][height];
  for (int y=0; y<height; y++) {
    for (int x=0; x<width; x++) {
      float distance = dist(900, 100, x, y);
      distances[x][y] = maxDist*30/distance;}}
  
  spacer = 1;                                            //spacer is one, because it looks smoother than spacer 10
  noStroke();

  seaGradient = new float[width];                        //setup for the lighting from the reflecting moon onto the water surface 
  for (int z=0; z<width; z++) {
    float amount = map(z, 0, width, 0, 0.56*PI);
    seaGradient[z] = abs(cos(amount));}
  noLoop();                                              //noLoop, so the stars and the waves do not change while looking at the sketch
}


void Lstar(float LstarX, float LstarY)                   //the large stars in the sky
{
  pushMatrix();
  translate(LstarX, LstarY);
  fill(255);
  ellipse(0, 0, 3, 3);
  popMatrix();
}

void Sstar(float SstarX, float SstarY)                   //the small stars in the sky
{
  pushMatrix();
  translate(SstarX, SstarY);
  fill(255);
  ellipse(0, 0, 1.8, 1.8);
  popMatrix();
}

void wave(float waveX, float waveY)                      //the waves in the water surface
{
  pushMatrix();
  translate(waveX, waveY);
  stroke(#0B1236);
  noFill();
  bezier(0, 410, 25, 435, 50, 385, 75, 410);
  popMatrix();
}


void draw() 
{                              
  background(#070C17);                                   //the dark blueish color in the sea and in the sky     
  
  for (int y=0; y<height-200; y+=spacer) {               //the lighting from the reflecting moon
    for (int x=0; x<width; x+=spacer) {
      stroke(distances[x][y]);
      point(x+spacer/2, y+spacer/2);}}

  noStroke();
   
  for (int s=0; s<41; s++) {                             //the larger stars appear in a random place in the sky
    Lstar(random(1000), random(397));}
    
  for (int s=0; s<31; s++) {                             //the smaller stars appear in a random place in the sky 
    Sstar(random(1000), random(398.2));}

  int seaX = 0;                                          //creating the shape where the gradient in the sea should look like a reflection
  int seaY = height/3;
  seaX = seaY;
  seaY = seaX + seaX;
  seaX = seaY;
  seaY = height;
  
  pushStyle();                                           //the lighting from the reflecting moon onto the water surface
  for (int v=0; v<width; v++) {
  blendMode(SCREEN);
  stroke(50 - seaGradient[v]*100);
  line(v, seaX, v, seaY);} 
  popStyle();

  for (int w=0; w<900; w++) {                            //the waves appear in a random spot on the watersurface
    wave(random(1000), random(410));
    wave(0, 0);}
    
  noStroke();
  fill(255);
  ellipse(900, 100, r, r);                               //moon
  fill(#0B2716);
  triangle(220,400,680,350,1200,400);                    //mountain right
  fill(#082112);
  triangle(0,400,180,250,400,400);                       //mountain middle left
  fill(#021F0D);
  triangle(100,400,330,300,600,400);                     //mountain middle right
  fill(#011A0B);
  triangle(-100,400,70,240,300,400);                     //mountain left
  fill(#270101);
  rect(200,220,20,210);                                  //left pillar
  fill(#550404);
  rect(216,220,4,210);
  fill(#270101);
  rect(360,220,20,210);                                  //right pillar
  fill(#550404);
  rect(376,220,4,210);
  fill(#270101);
  rect(280,240,20,45);                                   //middle bar
  fill(#550404);
  rect(296,240,4,45);
  fill(#270101);
  rect(165,260,250,15);                                  //low crossbar
  fill(#550404);
  rect(411,260,4,15);
  fill(#270101);
  rect(180,220,220,20);                                  //high crossbar
  fill(#550404);
  rect(396,220,4,20);
  fill(5);
  rect(190,410,40,50);                                   //left underpillar
  fill(25);
  rect(225,410,5,50);
  fill(5);
  rect(350,410,40,50);                                   //right underpillar
  fill(25);
  rect(385,410,5,50);
  fill(5);
  bezier(130,200,170,240,410,240,450,200);               //round crossbar top
  fill(16);
  bezier(120,198,170,215,410,215,460,198);               //round crossbar bottom
}
